function popdensity(xout,aout,nbins)
%find population density of attached crossbridges

%input variables:
%  xout = array of crossbridge displacements
%  aout = array of crossbridge states (0=detached,1=attached)
%  nbins = number of bins 

%Create x and a vectors from output arrays from Simulink
xout=xout(size(xout,1),:);
aout=aout(size(aout,1),:);

n0=size(xout,2); %total number of crossbridges
Nabridges=length(xout(find(aout)));  %number of attached crossbridges

%nabridges=number of attached crossbridges in each bin; 
%xc=centers of the bins:
[nabridges,xc]=hist(xout(find(aout)),nbins);

%normalize nabridges to find crossbridge population density
xstep=xc(2)-xc(1);

u = (nabridges/n0)/xstep;  % Why is this? (Hint: look at units)

plot(xc,u,'*') %plot population density
title('Crossbridge Population Density vs. Bin Centers');
xlabel('Bin Centers');
ylabel('Crossbridge Population Density');